---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-Partial Prerendering（PPR）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  1. 該当なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/lib/experimental/ppr.ts` - PPR設定チェック関数
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ExperimentalPPRConfig型がboolean \| 'incremental' | E-01 (9行目) | ○ |
| C-02 | checkIsAppPPREnabledでundefinedはfalse | E-01 (22行目) | ○ |
| C-03 | checkIsAppPPREnabledでbooleanはそのまま返す | E-01 (25行目) | ○ |
| C-04 | checkIsAppPPREnabledで'incremental'はtrue | E-01 (29行目) | ○ |
| C-05 | checkIsRoutePPREnabledでundefinedはfalse | E-01 (45行目) | ○ |
| C-06 | checkIsRoutePPREnabledでbooleanはそのまま返す | E-01 (49行目) | ○ |
| C-07 | checkIsRoutePPREnabledで'incremental'はfalse（暗黙のreturn false） | E-01 (51行目) | ○ |
| C-08 | PPRは実験的機能 | E-02 (38行目 "実験的機能") | ○ |
| C-09 | JSDocでcheckIsRoutePPREnabledとcheckIsAppPPREnabledの参照関係を記載 | E-01 (16-17行目, 40行目) | ○ |
| C-10 | checkIsAppPPREnabledのJSDocにcheckIsRoutePPREnabledへの参照あり | E-01 (16行目 @see) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - PPR設定チェックはシンプルな関数であり、ソースコードで完全に確認可能
- 注意: PPRの実装全体は多くのファイルにまたがるが、設定チェック部分は明確

## 6) レビュアーチェックリスト（最小）
- [ ] PPRの全体的な実装フロー（ビルド時の静的シェル生成）を確認
- [ ] incrementalモードのルートレベル設定（experimental_pprエクスポート）の動作を確認
